/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

public abstract class Record {
    public Record() {
    }

    public Record(short id, short size, byte[] data2) {
        this.validateSid(id);
        this.fillFields(data2, size);
    }

    public Record(short id, short size, byte[] data2, int offset) {
        this.validateSid(id);
        this.fillFields(data2, size, offset);
    }

    protected abstract void validateSid(short var1);

    protected void fillFields(byte[] data2, short size) {
        this.fillFields(data2, size, 0);
    }

    protected abstract void fillFields(byte[] var1, short var2, int var3);

    public byte[] serialize() {
        byte[] retval = new byte[this.getRecordSize()];
        this.serialize(0, retval);
        return retval;
    }

    public abstract int serialize(int var1, byte[] var2);

    public int getRecordSize() {
        return this.serialize().length;
    }

    public boolean isValue() {
        return false;
    }

    public boolean isInValueSection() {
        return false;
    }

    public String toString() {
        return super.toString();
    }

    public void processContinueRecord(byte[] record) {
    }

    public abstract short getSid();

    public Object clone() {
        throw new RuntimeException("The class " + this.getClass().getName() + " needs to define a clone method");
    }
}

