/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;

public class PrintGridlinesRecord
extends Record {
    public static final short sid = 43;
    private short field_1_print_gridlines;

    public PrintGridlinesRecord() {
    }

    public PrintGridlinesRecord(short id, short size, byte[] data2) {
        super(id, size, data2);
    }

    public PrintGridlinesRecord(short id, short size, byte[] data2, int offset) {
        super(id, size, data2, offset);
    }

    protected void validateSid(short id) {
        if (id != 43) {
            throw new RecordFormatException("NOT A PrintGridlines RECORD");
        }
    }

    protected void fillFields(byte[] data2, short size, int offset) {
        this.field_1_print_gridlines = LittleEndian.getShort(data2, 0 + offset);
    }

    public void setPrintGridlines(boolean pg) {
        this.field_1_print_gridlines = pg ? (short)1 : 0;
    }

    public boolean getPrintGridlines() {
        return this.field_1_print_gridlines == 1;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[PRINTGRIDLINES]\n");
        buffer.append("    .printgridlines = ").append(this.getPrintGridlines()).append("\n");
        buffer.append("[/PRINTGRIDLINES]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data2) {
        LittleEndian.putShort(data2, 0 + offset, (short)43);
        LittleEndian.putShort(data2, 2 + offset, (short)2);
        LittleEndian.putShort(data2, 4 + offset, this.field_1_print_gridlines);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 43;
    }

    public Object clone() {
        PrintGridlinesRecord rec = new PrintGridlinesRecord();
        rec.field_1_print_gridlines = this.field_1_print_gridlines;
        return rec;
    }
}

