/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;

public class PasswordRev4Record
extends Record {
    public static final short sid = 444;
    private short field_1_password;

    public PasswordRev4Record() {
    }

    public PasswordRev4Record(short id, short size, byte[] data2) {
        super(id, size, data2);
    }

    public PasswordRev4Record(short id, short size, byte[] data2, int offset) {
        super(id, size, data2, offset);
    }

    protected void validateSid(short id) {
        if (id != 444) {
            throw new RecordFormatException("NOT A PROT4REVPASSWORD RECORD");
        }
    }

    protected void fillFields(byte[] data2, short size, int offset) {
        this.field_1_password = LittleEndian.getShort(data2, 0 + offset);
    }

    public void setPassword(short pw) {
        this.field_1_password = pw;
    }

    public short getPassword() {
        return this.field_1_password;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[PROT4REVPASSWORD]\n");
        buffer.append("    .password       = ").append(Integer.toHexString(this.getPassword())).append("\n");
        buffer.append("[/PROT4REVPASSWORD]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data2) {
        LittleEndian.putShort(data2, 0 + offset, (short)444);
        LittleEndian.putShort(data2, 2 + offset, (short)2);
        LittleEndian.putShort(data2, 4 + offset, this.getPassword());
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 444;
    }
}

