/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public class NumberFormatIndexRecord
extends Record {
    public static final short sid = 4174;
    private short field_1_formatIndex;

    public NumberFormatIndexRecord() {
    }

    public NumberFormatIndexRecord(short id, short size, byte[] data2) {
        super(id, size, data2);
    }

    public NumberFormatIndexRecord(short id, short size, byte[] data2, int offset) {
        super(id, size, data2, offset);
    }

    protected void validateSid(short id) {
        if (id != 4174) {
            throw new RecordFormatException("Not a NumberFormatIndex record");
        }
    }

    protected void fillFields(byte[] data2, short size, int offset) {
        int pos = 0;
        this.field_1_formatIndex = LittleEndian.getShort(data2, pos + 0 + offset);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[IFMT]\n");
        buffer.append("    .formatIndex          = ").append("0x").append(HexDump.toHex(this.getFormatIndex())).append(" (").append(this.getFormatIndex()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("[/IFMT]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data2) {
        int pos = 0;
        LittleEndian.putShort(data2, 0 + offset, (short)4174);
        LittleEndian.putShort(data2, 2 + offset, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(data2, 4 + offset + pos, this.field_1_formatIndex);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 4174;
    }

    public Object clone() {
        NumberFormatIndexRecord rec = new NumberFormatIndexRecord();
        rec.field_1_formatIndex = this.field_1_formatIndex;
        return rec;
    }

    public short getFormatIndex() {
        return this.field_1_formatIndex;
    }

    public void setFormatIndex(short field_1_formatIndex) {
        this.field_1_formatIndex = field_1_formatIndex;
    }
}

