/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Margin;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;

public class LeftMarginRecord
extends Record
implements Margin {
    public static final short sid = 38;
    private double field_1_margin;

    public LeftMarginRecord() {
    }

    public LeftMarginRecord(short id, short size, byte[] data2) {
        super(id, size, data2);
    }

    public LeftMarginRecord(short id, short size, byte[] data2, int offset) {
        super(id, size, data2, offset);
    }

    protected void validateSid(short id) {
        if (id != 38) {
            throw new RecordFormatException("Not a LeftMargin record");
        }
    }

    protected void fillFields(byte[] data2, short size, int offset) {
        this.field_1_margin = LittleEndian.getDouble(data2, 0 + offset);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[LeftMargin]\n");
        buffer.append("    .margin               = ").append(" (").append(this.getMargin()).append(" )\n");
        buffer.append("[/LeftMargin]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data2) {
        LittleEndian.putShort(data2, 0 + offset, (short)38);
        LittleEndian.putShort(data2, 2 + offset, (short)(this.getRecordSize() - 4));
        LittleEndian.putDouble(data2, 4 + offset, this.field_1_margin);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 12;
    }

    public short getSid() {
        return 38;
    }

    public double getMargin() {
        return this.field_1_margin;
    }

    public void setMargin(double field_1_margin) {
        this.field_1_margin = field_1_margin;
    }

    public Object clone() {
        LeftMarginRecord rec = new LeftMarginRecord();
        rec.field_1_margin = this.field_1_margin;
        return rec;
    }
}

