/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;

public class IterationRecord
extends Record {
    public static final short sid = 17;
    private short field_1_iteration;

    public IterationRecord() {
    }

    public IterationRecord(short id, short size, byte[] data2) {
        super(id, size, data2);
    }

    public IterationRecord(short id, short size, byte[] data2, int offset) {
        super(id, size, data2, offset);
    }

    protected void validateSid(short id) {
        if (id != 17) {
            throw new RecordFormatException("NOT An ITERATION RECORD");
        }
    }

    protected void fillFields(byte[] data2, short size, int offset) {
        this.field_1_iteration = LittleEndian.getShort(data2, 0 + offset);
    }

    public void setIteration(boolean iterate) {
        this.field_1_iteration = iterate ? (short)1 : 0;
    }

    public boolean getIteration() {
        return this.field_1_iteration == 1;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[ITERATION]\n");
        buffer.append("    .iteration      = ").append(this.getIteration()).append("\n");
        buffer.append("[/ITERATION]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data2) {
        LittleEndian.putShort(data2, 0 + offset, (short)17);
        LittleEndian.putShort(data2, 2 + offset, (short)2);
        LittleEndian.putShort(data2, 4 + offset, this.field_1_iteration);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 17;
    }

    public Object clone() {
        IterationRecord rec = new IterationRecord();
        rec.field_1_iteration = this.field_1_iteration;
        return rec;
    }
}

