/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.SubRecord;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public class GroupMarkerSubRecord
extends SubRecord {
    public static final short sid = 6;
    private byte[] reserved = new byte[0];

    public GroupMarkerSubRecord() {
    }

    public GroupMarkerSubRecord(short id, short size, byte[] data2) {
        super(id, size, data2);
    }

    public GroupMarkerSubRecord(short id, short size, byte[] data2, int offset) {
        super(id, size, data2, offset);
    }

    protected void validateSid(short id) {
        if (id != 6) {
            throw new RecordFormatException("Not a Group Marker record");
        }
    }

    protected void fillFields(byte[] data2, short size, int offset) {
        this.reserved = new byte[size];
        System.arraycopy(data2, offset, this.reserved, 0, size);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        String nl = System.getProperty("line.separator");
        buffer.append("[ftGmo]" + nl);
        buffer.append("  reserved = ").append(HexDump.toHex(this.reserved)).append(nl);
        buffer.append("[/ftGmo]" + nl);
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data2) {
        LittleEndian.putShort(data2, 0 + offset, (short)6);
        LittleEndian.putShort(data2, 2 + offset, (short)(this.getRecordSize() - 4));
        System.arraycopy(this.reserved, 0, data2, offset + 4, this.getRecordSize() - 4);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 4 + this.reserved.length;
    }

    public short getSid() {
        return 6;
    }

    public Object clone() {
        GroupMarkerSubRecord rec = new GroupMarkerSubRecord();
        rec.reserved = new byte[this.reserved.length];
        for (int i = 0; i < this.reserved.length; ++i) {
            rec.reserved[i] = this.reserved[i];
        }
        return rec;
    }
}

