/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.StringUtil;

public class FormatRecord
extends Record {
    public static final short sid = 1054;
    private short field_1_index_code;
    private short field_2_formatstring_len;
    private short field_3_unicode_len;
    private boolean field_3_unicode_flag;
    private String field_4_formatstring;

    public FormatRecord() {
    }

    public FormatRecord(short id, short size, byte[] data2) {
        super(id, size, data2);
    }

    public FormatRecord(short id, short size, byte[] data2, int offset) {
        super(id, size, data2, offset);
    }

    protected void validateSid(short id) {
        if (id != 1054) {
            throw new RecordFormatException("NOT A FORMAT RECORD");
        }
    }

    protected void fillFields(byte[] data2, short size, int offset) {
        this.field_1_index_code = LittleEndian.getShort(data2, 0 + offset);
        this.field_2_formatstring_len = this.field_3_unicode_len = LittleEndian.getShort(data2, 2 + offset);
        this.field_3_unicode_flag = (data2[4 + offset] & 1) != 0;
        this.field_4_formatstring = this.field_3_unicode_flag ? StringUtil.getFromUnicodeHigh(data2, 5 + offset, this.field_3_unicode_len) : StringUtil.getFromCompressedUnicode(data2, 5 + offset, this.field_3_unicode_len);
    }

    public void setIndexCode(short index) {
        this.field_1_index_code = index;
    }

    public void setFormatStringLength(byte len) {
        this.field_2_formatstring_len = len;
        this.field_3_unicode_len = len;
    }

    public void setUnicodeFlag(boolean unicode) {
        this.field_3_unicode_flag = unicode;
    }

    public void setFormatString(String fs) {
        this.field_4_formatstring = fs;
    }

    public short getIndexCode() {
        return this.field_1_index_code;
    }

    public short getFormatStringLength() {
        return this.field_3_unicode_flag ? this.field_3_unicode_len : this.field_2_formatstring_len;
    }

    public boolean getUnicodeFlag() {
        return this.field_3_unicode_flag;
    }

    public String getFormatString() {
        return this.field_4_formatstring;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[FORMAT]\n");
        buffer.append("    .indexcode       = ").append(Integer.toHexString(this.getIndexCode())).append("\n");
        buffer.append("    .unicode length  = ").append(Integer.toHexString(this.field_3_unicode_len)).append("\n");
        buffer.append("    .isUnicode       = ").append(this.field_3_unicode_flag).append("\n");
        buffer.append("    .formatstring    = ").append(this.getFormatString()).append("\n");
        buffer.append("[/FORMAT]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data2) {
        LittleEndian.putShort(data2, 0 + offset, (short)1054);
        LittleEndian.putShort(data2, 2 + offset, (short)(5 + (this.field_3_unicode_flag ? 2 * this.field_3_unicode_len : this.field_3_unicode_len)));
        LittleEndian.putShort(data2, 4 + offset, this.getIndexCode());
        LittleEndian.putShort(data2, 6 + offset, this.field_3_unicode_len);
        data2[8 + offset] = (byte)(this.field_3_unicode_flag ? 1 : 0);
        if (this.field_3_unicode_flag) {
            StringUtil.putUncompressedUnicode(this.getFormatString(), data2, 9 + offset);
        } else {
            StringUtil.putCompressedUnicode(this.getFormatString(), data2, 9 + offset);
        }
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 9 + (this.field_3_unicode_flag ? 2 * this.field_3_unicode_len : this.field_3_unicode_len);
    }

    public short getSid() {
        return 1054;
    }
}

