/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.util.ArrayList;
import org.apache.poi.hssf.record.ExternSheetSubRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;

public class ExternSheetRecord
extends Record {
    public static final short sid = 23;
    private short field_1_number_of_REF_sturcutres;
    private ArrayList field_2_REF_structures;

    public ExternSheetRecord() {
        this.field_2_REF_structures = new ArrayList();
    }

    public ExternSheetRecord(short id, short size, byte[] data2) {
        super(id, size, data2);
    }

    public ExternSheetRecord(short id, short size, byte[] data2, int offset) {
        super(id, size, data2, offset);
    }

    protected void validateSid(short id) {
        if (id != 23) {
            throw new RecordFormatException("NOT An ExternSheet RECORD");
        }
    }

    protected void fillFields(byte[] data2, short size, int offset) {
        this.field_2_REF_structures = new ArrayList();
        this.field_1_number_of_REF_sturcutres = LittleEndian.getShort(data2, 0 + offset);
        int pos = 2 + offset;
        for (int i = 0; i < this.field_1_number_of_REF_sturcutres; ++i) {
            ExternSheetSubRecord rec = new ExternSheetSubRecord(0, 6, data2, pos);
            pos += 6;
            this.field_2_REF_structures.add(rec);
        }
    }

    public void setNumOfREFStructures(short numStruct) {
        this.field_1_number_of_REF_sturcutres = numStruct;
    }

    public short getNumOfREFStructures() {
        return this.field_1_number_of_REF_sturcutres;
    }

    public void addREFRecord(ExternSheetSubRecord rec) {
        this.field_2_REF_structures.add(rec);
    }

    public int getNumOfREFRecords() {
        return this.field_2_REF_structures.size();
    }

    public ExternSheetSubRecord getREFRecordAt(int elem) {
        ExternSheetSubRecord result = (ExternSheetSubRecord)this.field_2_REF_structures.get(elem);
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[EXTERNSHEET]\n");
        buffer.append("   numOfRefs     = ").append(this.getNumOfREFStructures()).append("\n");
        for (int k = 0; k < this.getNumOfREFRecords(); ++k) {
            buffer.append("refrec         #").append(k).append('\n');
            buffer.append(this.getREFRecordAt(k).toString());
            buffer.append("----refrec     #").append(k).append('\n');
        }
        buffer.append("[/EXTERNSHEET]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data2) {
        LittleEndian.putShort(data2, 0 + offset, (short)23);
        LittleEndian.putShort(data2, 2 + offset, (short)(2 + this.getNumOfREFRecords() * 6));
        LittleEndian.putShort(data2, 4 + offset, this.getNumOfREFStructures());
        int pos = 6;
        for (int k = 0; k < this.getNumOfREFRecords(); ++k) {
            ExternSheetSubRecord record = this.getREFRecordAt(k);
            System.arraycopy(record.serialize(), 0, data2, pos + offset, 6);
            pos += 6;
        }
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 6 + this.getNumOfREFRecords() * 6;
    }

    public short getSid() {
        return 23;
    }
}

