/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;

public class EndRecord
extends Record {
    public static final short sid = 4148;

    public EndRecord() {
    }

    public EndRecord(short id, short size, byte[] data2) {
        super(id, size, data2);
    }

    public EndRecord(short id, short size, byte[] data2, int offset) {
        super(id, size, data2, offset);
    }

    protected void validateSid(short id) {
        if (id != 4148) {
            throw new RecordFormatException("NOT An END RECORD");
        }
    }

    protected void fillFields(byte[] data2, short size, int offset) {
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[END]\n");
        buffer.append("[/END]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data2) {
        LittleEndian.putShort(data2, 0 + offset, (short)4148);
        LittleEndian.putShort(data2, 2 + offset, (short)0);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 4;
    }

    public short getSid() {
        return 4148;
    }
}

