/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;

public class DateWindow1904Record
extends Record {
    public static final short sid = 34;
    private short field_1_window;

    public DateWindow1904Record() {
    }

    public DateWindow1904Record(short id, short size, byte[] data2) {
        super(id, size, data2);
    }

    public DateWindow1904Record(short id, short size, byte[] data2, int offset) {
        super(id, size, data2, offset);
    }

    protected void validateSid(short id) {
        if (id != 34) {
            throw new RecordFormatException("NOT A 1904 RECORD");
        }
    }

    protected void fillFields(byte[] data2, short size, int offset) {
        this.field_1_window = LittleEndian.getShort(data2, 0 + offset);
    }

    public void setWindowing(short window) {
        this.field_1_window = window;
    }

    public short getWindowing() {
        return this.field_1_window;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[1904]\n");
        buffer.append("    .is1904          = ").append(Integer.toHexString(this.getWindowing())).append("\n");
        buffer.append("[/1904]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data2) {
        LittleEndian.putShort(data2, 0 + offset, (short)34);
        LittleEndian.putShort(data2, 2 + offset, (short)2);
        LittleEndian.putShort(data2, 4 + offset, this.getWindowing());
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 34;
    }
}

