/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;

public class DSFRecord
extends Record {
    public static final short sid = 353;
    private short field_1_dsf;

    public DSFRecord() {
    }

    public DSFRecord(short id, short size, byte[] data2) {
        super(id, size, data2);
    }

    public DSFRecord(short id, short size, byte[] data2, int offset) {
        super(id, size, data2, offset);
    }

    protected void validateSid(short id) {
        if (id != 353) {
            throw new RecordFormatException("NOT A DSF RECORD");
        }
    }

    protected void fillFields(byte[] data2, short size, int offset) {
        this.field_1_dsf = LittleEndian.getShort(data2, 0 + offset);
    }

    public void setDsf(short dsfflag) {
        this.field_1_dsf = dsfflag;
    }

    public short getDsf() {
        return this.field_1_dsf;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[DSF]\n");
        buffer.append("    .isDSF           = ").append(Integer.toHexString(this.getDsf())).append("\n");
        buffer.append("[/DSF]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data2) {
        LittleEndian.putShort(data2, 0 + offset, (short)353);
        LittleEndian.putShort(data2, 2 + offset, (short)2);
        LittleEndian.putShort(data2, 4 + offset, this.getDsf());
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 353;
    }
}

