/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;

public class CountryRecord
extends Record {
    public static final short sid = 140;
    private short field_1_default_country;
    private short field_2_current_country;

    public CountryRecord() {
    }

    public CountryRecord(short id, short size, byte[] data2) {
        super(id, size, data2);
    }

    public CountryRecord(short id, short size, byte[] data2, int offset) {
        super(id, size, data2, offset);
    }

    protected void validateSid(short id) {
        if (id != 140) {
            throw new RecordFormatException("NOT A Country RECORD");
        }
    }

    protected void fillFields(byte[] data2, short size, int offset) {
        this.field_1_default_country = LittleEndian.getShort(data2, 0 + offset);
        this.field_2_current_country = LittleEndian.getShort(data2, 2 + offset);
    }

    public void setDefaultCountry(short country) {
        this.field_1_default_country = country;
    }

    public void setCurrentCountry(short country) {
        this.field_2_current_country = country;
    }

    public short getDefaultCountry() {
        return this.field_1_default_country;
    }

    public short getCurrentCountry() {
        return this.field_2_current_country;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[COUNTRY]\n");
        buffer.append("    .defaultcountry  = ").append(Integer.toHexString(this.getDefaultCountry())).append("\n");
        buffer.append("    .currentcountry  = ").append(Integer.toHexString(this.getCurrentCountry())).append("\n");
        buffer.append("[/COUNTRY]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data2) {
        LittleEndian.putShort(data2, 0 + offset, (short)140);
        LittleEndian.putShort(data2, 2 + offset, (short)4);
        LittleEndian.putShort(data2, 4 + offset, this.getDefaultCountry());
        LittleEndian.putShort(data2, 6 + offset, this.getCurrentCountry());
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 8;
    }

    public short getSid() {
        return 140;
    }
}

