/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.BitField;
import org.apache.poi.util.LittleEndian;

public class ChartFormatRecord
extends Record {
    public static final short sid = 4116;
    private int field1_x_position;
    private int field2_y_position;
    private int field3_width;
    private int field4_height;
    private short field5_grbit;
    private BitField varyDisplayPattern = new BitField(1);

    public ChartFormatRecord() {
    }

    public ChartFormatRecord(short id, short size, byte[] data2) {
        super(id, size, data2);
    }

    public ChartFormatRecord(short id, short size, byte[] data2, int offset) {
        super(id, size, data2, offset);
    }

    protected void validateSid(short id) {
        if (id != 4116) {
            throw new RecordFormatException("NOT A CHARTFORMAT RECORD");
        }
    }

    protected void fillFields(byte[] data2, short size, int offset) {
        this.field1_x_position = LittleEndian.getInt(data2, 0 + offset);
        this.field2_y_position = LittleEndian.getInt(data2, 4 + offset);
        this.field3_width = LittleEndian.getInt(data2, 8 + offset);
        this.field4_height = LittleEndian.getInt(data2, 12 + offset);
        this.field5_grbit = LittleEndian.getShort(data2, 16 + offset);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[CHARTFORMAT]\n");
        buffer.append("    .xPosition       = ").append(this.getXPosition()).append("\n");
        buffer.append("    .yPosition       = ").append(this.getYPosition()).append("\n");
        buffer.append("    .width           = ").append(this.getWidth()).append("\n");
        buffer.append("    .height          = ").append(this.getHeight()).append("\n");
        buffer.append("    .grBit           = ").append(Integer.toHexString(this.field5_grbit)).append("\n");
        buffer.append("[/CHARTFORMAT]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data2) {
        LittleEndian.putShort(data2, 0 + offset, (short)4116);
        LittleEndian.putShort(data2, 2 + offset, (short)22);
        LittleEndian.putInt(data2, 4 + offset, this.getXPosition());
        LittleEndian.putInt(data2, 8 + offset, this.getYPosition());
        LittleEndian.putInt(data2, 12 + offset, this.getWidth());
        LittleEndian.putInt(data2, 16 + offset, this.getHeight());
        LittleEndian.putShort(data2, 20 + offset, this.field5_grbit);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 22;
    }

    public short getSid() {
        return 4116;
    }

    public int getXPosition() {
        return this.field1_x_position;
    }

    public void setXPosition(int xPosition) {
        this.field1_x_position = xPosition;
    }

    public int getYPosition() {
        return this.field2_y_position;
    }

    public void setYPosition(int yPosition) {
        this.field2_y_position = yPosition;
    }

    public int getWidth() {
        return this.field3_width;
    }

    public void setWidth(int width) {
        this.field3_width = width;
    }

    public int getHeight() {
        return this.field4_height;
    }

    public void setHeight(int height) {
        this.field4_height = height;
    }

    public boolean getVaryDisplayPattern() {
        return this.varyDisplayPattern.isSet(this.field5_grbit);
    }

    public void setVaryDisplayPattern(boolean value) {
        this.field5_grbit = this.varyDisplayPattern.setShortBoolean(this.field5_grbit, value);
    }
}

