/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.StringUtil;

public class BoundSheetRecord
extends Record {
    public static final short sid = 133;
    private int field_1_position_of_BOF;
    private short field_2_option_flags;
    private byte field_3_sheetname_length;
    private byte field_4_compressed_unicode_flag;
    private String field_5_sheetname;

    public BoundSheetRecord() {
    }

    public BoundSheetRecord(short id, short size, byte[] data2) {
        super(id, size, data2);
    }

    public BoundSheetRecord(short id, short size, byte[] data2, int offset) {
        super(id, size, data2, offset);
    }

    protected void validateSid(short id) {
        if (id != 133) {
            throw new RecordFormatException("NOT A Bound Sheet RECORD");
        }
    }

    protected void fillFields(byte[] data2, short size, int offset) {
        this.field_1_position_of_BOF = LittleEndian.getInt(data2, 0 + offset);
        this.field_2_option_flags = LittleEndian.getShort(data2, 4 + offset);
        this.field_3_sheetname_length = data2[6 + offset];
        this.field_4_compressed_unicode_flag = data2[7 + offset];
        int nameLength = LittleEndian.ubyteToInt(this.field_3_sheetname_length);
        this.field_5_sheetname = (this.field_4_compressed_unicode_flag & 1) == 1 ? StringUtil.getFromUnicodeHigh(data2, 8 + offset, nameLength) : StringUtil.getFromCompressedUnicode(data2, 8 + offset, nameLength);
    }

    public void setPositionOfBof(int pos) {
        this.field_1_position_of_BOF = pos;
    }

    public void setOptionFlags(short flags) {
        this.field_2_option_flags = flags;
    }

    public void setSheetnameLength(byte len) {
        this.field_3_sheetname_length = len;
    }

    public void setCompressedUnicodeFlag(byte flag) {
        this.field_4_compressed_unicode_flag = flag;
    }

    public void setSheetname(String sheetname) {
        if (sheetname == null || sheetname.length() == 0 || sheetname.length() > 31 || sheetname.indexOf("/") > -1 || sheetname.indexOf("\\") > -1 || sheetname.indexOf("?") > -1 || sheetname.indexOf("*") > -1 || sheetname.indexOf("]") > -1 || sheetname.indexOf("[") > -1) {
            throw new IllegalArgumentException("Sheet name cannot be blank, greater than 31 chars, or contain any of /\\*?[]");
        }
        this.field_5_sheetname = sheetname;
    }

    public int getPositionOfBof() {
        return this.field_1_position_of_BOF;
    }

    public short getOptionFlags() {
        return this.field_2_option_flags;
    }

    public byte getSheetnameLength() {
        return this.field_3_sheetname_length;
    }

    public byte getRawSheetnameLength() {
        return (byte)((this.field_4_compressed_unicode_flag & 1) == 1 ? 2 * this.field_3_sheetname_length : this.field_3_sheetname_length);
    }

    public byte getCompressedUnicodeFlag() {
        return this.field_4_compressed_unicode_flag;
    }

    public String getSheetname() {
        return this.field_5_sheetname;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[BOUNDSHEET]\n");
        buffer.append("    .bof             = ").append(Integer.toHexString(this.getPositionOfBof())).append("\n");
        buffer.append("    .optionflags     = ").append(Integer.toHexString(this.getOptionFlags())).append("\n");
        buffer.append("    .sheetname length= ").append(Integer.toHexString(this.getSheetnameLength())).append("\n");
        buffer.append("    .unicodeflag     = ").append(Integer.toHexString(this.getCompressedUnicodeFlag())).append("\n");
        buffer.append("    .sheetname       = ").append(this.getSheetname()).append("\n");
        buffer.append("[/BOUNDSHEET]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data2) {
        LittleEndian.putShort(data2, 0 + offset, (short)133);
        LittleEndian.putShort(data2, 2 + offset, (short)(8 + this.getRawSheetnameLength()));
        LittleEndian.putInt(data2, 4 + offset, this.getPositionOfBof());
        LittleEndian.putShort(data2, 8 + offset, this.getOptionFlags());
        data2[10 + offset] = this.getSheetnameLength();
        data2[11 + offset] = this.getCompressedUnicodeFlag();
        if ((this.field_4_compressed_unicode_flag & 1) == 1) {
            StringUtil.putUncompressedUnicode(this.getSheetname(), data2, 12 + offset);
        } else {
            StringUtil.putCompressedUnicode(this.getSheetname(), data2, 12 + offset);
        }
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 12 + this.getRawSheetnameLength();
    }

    public short getSid() {
        return 133;
    }
}

