/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public class AxisLineFormatRecord
extends Record {
    public static final short sid = 4129;
    private short field_1_axisType;
    public static final short AXIS_TYPE_AXIS_LINE = 0;
    public static final short AXIS_TYPE_MAJOR_GRID_LINE = 1;
    public static final short AXIS_TYPE_MINOR_GRID_LINE = 2;
    public static final short AXIS_TYPE_WALLS_OR_FLOOR = 3;

    public AxisLineFormatRecord() {
    }

    public AxisLineFormatRecord(short id, short size, byte[] data2) {
        super(id, size, data2);
    }

    public AxisLineFormatRecord(short id, short size, byte[] data2, int offset) {
        super(id, size, data2, offset);
    }

    protected void validateSid(short id) {
        if (id != 4129) {
            throw new RecordFormatException("Not a AxisLineFormat record");
        }
    }

    protected void fillFields(byte[] data2, short size, int offset) {
        int pos = 0;
        this.field_1_axisType = LittleEndian.getShort(data2, pos + 0 + offset);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[AXISLINEFORMAT]\n");
        buffer.append("    .axisType             = ").append("0x").append(HexDump.toHex(this.getAxisType())).append(" (").append(this.getAxisType()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("[/AXISLINEFORMAT]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data2) {
        int pos = 0;
        LittleEndian.putShort(data2, 0 + offset, (short)4129);
        LittleEndian.putShort(data2, 2 + offset, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(data2, 4 + offset + pos, this.field_1_axisType);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 6;
    }

    public short getSid() {
        return 4129;
    }

    public Object clone() {
        AxisLineFormatRecord rec = new AxisLineFormatRecord();
        rec.field_1_axisType = this.field_1_axisType;
        return rec;
    }

    public short getAxisType() {
        return this.field_1_axisType;
    }

    public void setAxisType(short field_1_axisType) {
        this.field_1_axisType = field_1_axisType;
    }
}

