/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.ddf.DefaultEscherRecordFactory;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.NullEscherSerializationListener;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;

public abstract class AbstractEscherHolderRecord
extends Record {
    private static final boolean DESERIALISE = System.getProperty("poi.deserialize.escher") != null;
    private List escherRecords;
    private byte[] rawData;

    public AbstractEscherHolderRecord() {
        this.escherRecords = new ArrayList();
    }

    public AbstractEscherHolderRecord(short id, short size, byte[] data2) {
        super(id, size, data2);
    }

    public AbstractEscherHolderRecord(short id, short size, byte[] data2, int offset) {
        super(id, size, data2, offset);
    }

    protected void validateSid(short id) {
        if (id != this.getSid()) {
            throw new RecordFormatException("Not a Bar record");
        }
    }

    protected void fillFields(byte[] data2, short size, int offset) {
        this.escherRecords = new ArrayList();
        if (!DESERIALISE) {
            this.rawData = new byte[size];
            System.arraycopy(data2, offset, this.rawData, 0, size);
        } else {
            int bytesRead;
            DefaultEscherRecordFactory recordFactory = new DefaultEscherRecordFactory();
            for (int pos = offset; pos < offset + size; pos += bytesRead) {
                EscherRecord r = recordFactory.createRecord(data2, pos);
                bytesRead = r.fillFields(data2, pos, recordFactory);
                this.escherRecords.add(r);
            }
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        String nl = System.getProperty("line.separator");
        buffer.append('[' + this.getRecordName() + ']' + nl);
        Iterator iterator = this.escherRecords.iterator();
        while (iterator.hasNext()) {
            EscherRecord r = (EscherRecord)iterator.next();
            buffer.append(r.toString());
        }
        buffer.append("[/" + this.getRecordName() + ']' + nl);
        return buffer.toString();
    }

    protected abstract String getRecordName();

    public int serialize(int offset, byte[] data2) {
        LittleEndian.putShort(data2, 0 + offset, this.getSid());
        LittleEndian.putShort(data2, 2 + offset, (short)(this.getRecordSize() - 4));
        if (this.escherRecords.size() == 0 && this.rawData != null) {
            System.arraycopy(this.rawData, 0, data2, offset + 4, this.rawData.length);
        } else {
            int pos = offset + 4;
            Iterator iterator = this.escherRecords.iterator();
            while (iterator.hasNext()) {
                EscherRecord r = (EscherRecord)iterator.next();
                pos += r.serialize(pos, data2, new NullEscherSerializationListener());
            }
        }
        return this.getRecordSize();
    }

    public int getRecordSize() {
        if (this.escherRecords.size() == 0 && this.rawData != null) {
            return this.rawData.length + 4;
        }
        int size = 4;
        Iterator iterator = this.escherRecords.iterator();
        while (iterator.hasNext()) {
            EscherRecord r = (EscherRecord)iterator.next();
            size += r.getRecordSize();
        }
        return size;
    }

    public abstract short getSid();

    public Object clone() {
        throw new IllegalStateException("Not implemented yet.");
    }

    public void addEscherRecord(int index, EscherRecord element) {
        this.escherRecords.add(index, element);
    }

    public boolean addEscherRecord(EscherRecord element) {
        return this.escherRecords.add(element);
    }

    public List getEscherRecords() {
        return this.escherRecords;
    }

    public void clearEscherRecords() {
        this.escherRecords.clear();
    }

    public EscherRecord getEscherRecord(int index) {
        return (EscherRecord)this.escherRecords.get(index);
    }
}

